VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DistributionPlotClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Enum DistributionPlotType
  dptClass
  dptTargetStrength
End Enum

Public Enum DistributionPlotAction
  dpaOptions
  dpaUnknown
  dpaChangeType
  dpaSpace1
End Enum

Private Enum MouseEventType
  MouseUp
  MouseDown
  MouseMove
  Cancel
End Enum

Private Const ANSI_CHARSET = 0
Private Const CLIP_CHARACTER_PRECIS = 1
Private Const FW_NORMAL = 400
Private Const FF_DONT_CARE = 0
Private Const FF_ROMAN = 16      '  Variable stroke width, serifed.
Private Const OUT_DEFAULT_PRECIS = 0
Private Const OUT_DEVICE_PRECIS = 5
Private Const PROOF_QUALITY = 2
Private Const VARIABLE_PITCH = 2

Private Const MIN_NBins = 3
Private Const MAX_NBins = 10

Private Declare Function CreateFont Lib "GDI32" Alias "CreateFontA" _
  (ByVal H As Long, ByVal W As Long, ByVal E As Long, ByVal O As Long, _
   ByVal W As Long, ByVal i As Long, ByVal u As Long, ByVal s As Long, _
   ByVal C As Long, ByVal OP As Long, ByVal CP As Long, ByVal Q As Long, _
   ByVal PAF As Long, ByVal f As String) As Long

Private Declare Function SelectObject Lib "GDI32" _
  (ByVal hDC As Long, ByVal hObject As Long) As Long

Private mAxisColor As Long
Private mBarPaneX0 As Long
Private mBarPaneX1 As Long
Private mBarPaneY0 As Long
Private mBarPaneY1 As Long
Private mBarSeparation As Long
Private mBarWidth As Long
Private mCategoryLabels() As String
Private mClassifier As ClassifierClass
Private mColor() As Long
Private mColormap As ColorMapClass
Private mCounts() As Long
Private mFocusColor As Long
Private mFont As Long
Private mGrandTotal As Long
Private mHaveFocus As Boolean
Private mMenu As Scripting.Dictionary
Private mNBins As Integer
Private mPercentTick As Integer
Private mPercentLabelGap As Integer
Private WithEvents mPicture As PictureBox
Attribute mPicture.VB_VarHelpID = -1
Private mPlotType As DistributionPlotType
Private mPrefix As String
Private mRangeMax As Single
Private mRangeMin As Single
Private mShowCategoryAxis As Boolean
Private mShowPercentAxis As Boolean
Private mShowTopArea As Boolean
Private mTimesliceCount As Integer
Private mTimesliceCurrent As Integer
Private mTimesliceFirst As Integer
Private mTimesliceMax As Integer
Private mTimes() As Date
Private mTotals() As Long
Private mTSMax As Single
Private mTSMin As Single

' For displaying track counts
Private mShowCounts As Boolean          ' If true, then show track data from HRP
Private mCountingAllTracks As Boolean   ' If true then show global counts
Private mTotalTracks As Long            ' corresponds to mGrandTotal - but for tracks
Private mTrackTotals() As Long          ' Totals for tracks

Public Event ContextMenuRequest(ByVal X As Long, ByVal Y As Long)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event StatusBar(ByVal statusText As String)
Public Event DimensionChange()

Private Sub AddMenuItem(ByVal caption As String, _
                        ByVal tag As Integer, _
                        Optional ByVal checked As Boolean = False, _
                        Optional ByVal enabled As Boolean = True, _
                        Optional ByVal visible As Boolean = True)
                        
  Dim item As Scripting.Dictionary
  Set item = New Scripting.Dictionary
  item.Add "caption", caption
  item.Add "tag", tag
  item.Add "checked", checked
  item.Add "enabled", enabled
  item.Add "visible", visible
  mMenu.Add CStr(tag), item
                    
End Sub

Private Sub CategoryAxisLayout()

  Dim i As Integer
  Dim mapName As String
  Dim X As Single
  Dim dx As Single
  
  If Not mColormap Is Nothing Then
  
    If mPlotType = dptClass Then
        
        If mClassifier Is Nothing Then Exit Sub
        For i = 0 To mNBins - 1
            mCategoryLabels(i) = mClassifier.GetClassName(i)
            mColor(i) = mColormap.GetColor(i + mClassifier.GetNImplicitClasses() - 1)
        Next i
        
    Else
    
        X = mTSMin
        dx = (mTSMax - mTSMin) / (mNBins - 2)
        
        'mCategoryLabels(0) = Format(((-80 + mTSMin) / 2), "###.0")
        mCategoryLabels(0) = "[" & Format(-80, "###") & ";" & Format(mTSMin, "###") & "]"
        If Not mColormap Is Nothing Then
            mColor(0) = mColormap.Colorize((-80 + mTSMin) / 2)
        Else
            mColor(0) = vbBlue
        End If
  
        For i = 1 To mNBins - 2
            mCategoryLabels(i) = Format((X + dx / 2), "###.0")
            mColor(i) = mColormap.Colorize(X + dx / 2)
            X = X + dx
        Next i
        
        'mCategoryLabels(mNBins - 1) = Format(((20 + mTSMax) / 2), "###.0")
        mCategoryLabels(mNBins - 1) = "[" & Format(mTSMax, "###") & ";" & Format(20, "###") & "]"
        If Not mColormap Is Nothing Then
            mColor(mNBins - 1) = mColormap.Colorize((20 + mTSMax) / 2)
        Else
            mColor(mNBins - 1) = vbBlue
        End If
        
    End If
    
  Else
            
    If mPlotType = dptClass Then
    
        '  Layout for class type categories
        '
        '  Find the colormap, if possible
        If mClassifier Is Nothing Then Exit Sub
        mapName = mClassifier.GetColorMapName
        If mapName <> "" Then
         Set mColormap = New ColorMapClass
        mColormap.ReadFromDB mapName
        End If
    
        ' Get the class name and class color.
        ' Trim class name to 12 characters.
        ' Default color is blue
    
        For i = 0 To mNBins - 1
          mCategoryLabels(i) = mClassifier.GetClassName(i)
          If Not mColormap Is Nothing Then
            mColor(i) = mColormap.GetColor(i + mClassifier.GetNImplicitClasses() - 1)
          Else
            mColor(i) = vbBlue
          End If
        Next i
    
    Else
  
        mapName = general.propertyList.GetProperty(mPrefix & ":ColorMapName", "_StandardEnergy")
        If mapName <> "" Then
            Set mColormap = New ColorMapClass
            mColormap.ReadFromDB mapName
        End If
      
        '  Layout for energy type plots
  
        X = mTSMin
        dx = (mTSMax - mTSMin) / (mNBins - 2)  ' AK Nov_2_2001
        mCategoryLabels(0) = "[" & Format(-80, "###") & ";" & Format(mTSMin, "###") & "]"
       
        If Not mColormap Is Nothing Then
            mColor(0) = mColormap.Colorize((-80 + mTSMin) / 2)
        Else
            mColor(0) = vbBlue
        End If
        
        For i = 1 To mNBins - 2
            mCategoryLabels(i) = Format((X + dx / 2), "###.0")
            If Not mColormap Is Nothing Then
                mColor(i) = mColormap.Colorize(X + dx / 2)
            Else
                mColor(i) = vbBlue
            End If
            X = X + dx
        Next i

        mCategoryLabels(mNBins - 1) = "[" & Format(mTSMax, "###") & ";" & Format(20, "###") & "]"
       
        If Not mColormap Is Nothing Then
            mColor(mNBins - 1) = mColormap.Colorize((20 + mTSMax) / 2)
        Else
            mColor(mNBins - 1) = vbBlue
        End If
        
    End If

  End If

End Sub

Private Sub CategoryAxisPaint()
                        
  Dim oldfont As Long
  
  '  Erase the axis area
  
  mPicture.Line (mBarPaneX0, mBarPaneY1 + 1)-(mPicture.width, mPicture.height), _
                mPicture.backcolor, BF
  
  oldfont = SelectObject(mPicture.hDC, mFont)
                        
  Dim X As Long
  Dim Y As Long
  X = mBarPaneX0 + mBarSeparation / 2 + mBarWidth / 2
  Y = mBarPaneY1 + 2
  
  Dim i As Integer
  
  If mNBins <= 10 Then
  
    For i = 0 To mNBins - 1
    
        mPicture.CurrentX = X
        mPicture.CurrentY = Y - 0.87 * 0.5 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.Print mCategoryLabels(i)
        X = X + mBarSeparation + mBarWidth
  
    Next i

  Else
  
    For i = 0 To mNBins - 1 Step 2
    
        mPicture.CurrentX = X
        mPicture.CurrentY = Y - 0.87 * 0.5 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.Print mCategoryLabels(i)
        X = X + 2 * (mBarSeparation + mBarWidth)
  
    Next i
    
  End If
  
  
  SelectObject mPicture.hDC, oldfont
                        
End Sub

Private Sub changeType()

  Dim text As String
  text = "Distribution plot is currently displaying "
  text = text & IIf(mPlotType = dptClass, "classes", "energy") & "."
  text = text & vbCrLf & vbCrLf & "Change plot so it displays "
  text = text & IIf(mPlotType = dptClass, "energy", "classes") & "?"
  
  Dim reply As Integer
  reply = MsgBox(text, vbYesNo + vbQuestion, "Change Distribution Plot Type")
  If reply = vbYes Then
    Me.PlotSetup mPrefix, mPicture, _
      IIf(mPlotType = dptClass, dptTargetStrength, dptClass), mRangeMin, _
      mRangeMax, mTimesliceMax, mNBins, mTSMin, mTSMax
    If mPlotType = dptClass Then
      mMenu.item(CStr(dpaOptions)).item("enabled") = False
    Else
      mMenu.item(CStr(dpaOptions)).item("enabled") = True
    End If
  End If
  
  RaiseEvent DimensionChange

End Sub

Public Sub FormatDPlot()

    Dim changed As Boolean
    
    changed = frmDistributionPlotFormat.GetResults(mTSMin, mTSMax, mNBins)

    If changed Then
        Me.PlotSetup mPrefix, mPicture, _
          IIf(mPlotType = dptClass, dptClass, dptTargetStrength), mRangeMin, _
          mRangeMax, mTimesliceMax, mNBins, mTSMin, mTSMax
    End If
    
    RaiseEvent DimensionChange
   
End Sub

Public Sub Clear()
  
  Dim i As Integer
  Dim j As Integer
  
  For i = 0 To mNBins - 1
  
    mTotals(i) = 0

    For j = 0 To mTimesliceMax - 1
      mCounts(i, j) = 0
    Next j
  
  Next i
  
  mGrandTotal = 0
  
  mTimesliceCount = 0
  mTimesliceCurrent = 0
  mTimesliceFirst = 1
  
  PlotPaint

End Sub

Public Function GetMenu() As Scripting.Dictionary

  Set GetMenu = mMenu

End Function

Private Sub InsertEchoes()
    
  ' Process each of the ping's echoes -> -> ->
  '   Note: first and last bins will include all "leftover" echoes
  Dim echo As EchoClass
  Dim tsBinWidth As Single
  Dim i As Integer
  Dim theBin As Integer
  Dim ts As Single
  Dim j As Integer

  
  nEchoes = general.sonarIF.GetNEchoes()
  For i = 0 To mNBins - 1: mCounts(i, mTimesliceCurrent) = 0: Next i ' zero out the counts
  tsBinWidth = (mTSMax - mTSMin) / (mNBins - 2)
  For i = 0 To nEchoes - 1
    Set echo = general.sonarIF.GetEcho(i)
    If echo.GetRange() >= mRangeMin And echo.GetRange() <= mRangeMax Then
      '  For echoes in the range window, determine the appropriate bin number
      
      If mPlotType = dptClass Then
        theBin = echo.GetClassification() ' class determines the bin
      Else  ' mPlotType is TS
        ' Calculate the appropriate bin
        theBin = mNBins - 1
        ts = echo.GetTargetStrength()
        For j = 0 To mNBins - 2
         If ts <= mTSMin + tsBinWidth * j Then
            theBin = j
            Exit For
         End If
        Next j
      End If

      '  Add one to the appropriate bin
        If theBin >= 0 Then   ' Filters out "bottom" in class plots
            mCounts(theBin, mTimesliceCurrent) = mCounts(theBin, mTimesliceCurrent) + 1
        End If
      
    End If
  Next i

End Sub

Public Sub MenuAction(ByVal action As DistributionPlotAction)

  '  Called by a menu handling object (probably a form) to effect
  '  the action requested by the menu.

  Select Case action
  
    Case dpaChangeType
      changeType
      
    Case dpaOptions
      FormatDPlot
      
    Case Else
      Debug.Assert False
      
  End Select

End Sub

Private Sub MouseController(ByVal theEvent As MouseEventType, _
                            ByVal Button As Integer, _
                            ByVal Shift As Integer, _
                            ByVal X As Single, _
                            ByVal Y As Single)
                            
  On Error GoTo oops:
  
  Dim raiseIt As Boolean
                       
  Select Case theEvent
  
    Case MouseUp
      If (Button And vbRightButton) <> 0 Then
         RaiseEvent ContextMenuRequest(X, Y)
      End If

    Case MouseMove
      raiseIt = False
      Dim result As String
      Dim xp As Long
      If X >= mBarPaneX0 And X <= mBarPaneX1 - 1 And _
         Y >= mBarPaneY0 And Y <= mBarPaneY1 Then
        xp = Fix((X - mBarSeparation / 2) / (mBarWidth + mBarSeparation))
        ' Check and correct boundary conditions
        xp = IIf(xp < LBound(mCategoryLabels), LBound(mCategoryLabels), xp)
        xp = IIf(xp > UBound(mCategoryLabels), UBound(mCategoryLabels), xp)
        If mPicture.Point(X, Y) = mPicture.backcolor Then
          raiseIt = False
        Else
          If IsShowingTrackCounts Then
             If mTotalTracks <> 0 Then
              result = mCategoryLabels(xp) & ": " & mTrackTotals(xp) & _
                       Format(mTrackTotals(xp) / mTotalTracks * 100, " (##0") & "%)" & " (tracks)"
            Else
              result = mCategoryLabels(xp) & ": 0 (0%)"
            End If
          Else
            If mGrandTotal <> 0 Then
              result = mCategoryLabels(xp) & ": " & mTotals(xp) & _
                       Format(mTotals(xp) / mGrandTotal * 100, " (##0") & "%)" & IIf(IsTracking, " (echoes)", "")
            Else
              result = mCategoryLabels(xp) & ": 0 (0%)"
            End If
          End If
          raiseIt = True
        End If
      Else
        raiseIt = False
      End If
      If Not raiseIt Then
        result = "Distribution Plot::" & _
                 IIf(mPlotType = dptClass, "class", "energy")
            
        If IsShowingTrackCounts Then
          result = result & " (tracks)"
        Else
          result = result & IIf(IsTracking, " (echoes)", "")
        End If
        
      Else
        RaiseEvent StatusBar(result)
      End If
      mPicture.ToolTipText = result
  End Select
                           
  Exit Sub
  
oops:  ' Trap unexpected errors
  ErrorBox
  
End Sub

Private Sub PercentAxisPaint()

  '  Erase the axis area

  mPicture.Line (mBarPaneX1 + 1, mBarPaneY0)-(mPicture.width, mBarPaneY1), _
                mPicture.backcolor, BF
                
  mPicture.CurrentX = mBarPaneX1 + mPercentLabelGap
  mPicture.CurrentY = mBarPaneY0
  mPicture.Print " %"

  Dim i As Integer
  Dim Y As Long
  
  For i = 90 To 10 Step -10
  
    '  Draw in a grid
    
    Y = (1 - (i / 100)) * (mBarPaneY1 - mBarPaneY0) + mBarPaneY0
    
    mPicture.DrawStyle = vbDot
    mPicture.Line (mBarPaneX0, Y)-(mBarPaneX1, Y), mAxisColor
    mPicture.DrawStyle = vbSolid
    
    '  Write in a label
    
    If i Mod 20 = 0 Then
    
      mPicture.Line (mBarPaneX1 + 1, Y)-Step(mPercentTick, 0), mAxisColor
      mPicture.CurrentX = mPicture.CurrentX + mPercentLabelGap
      mPicture.CurrentY = mPicture.CurrentY - mPicture.TextHeight(CStr(i)) / 2
      mPicture.Print CStr(i)
      
    End If
  
  Next i

End Sub

Public Sub PingArrived(ByVal pingNumber As Long)
 
  If mPlotType = dptClass Then
  
    ' For class type plots, check to see if the classifier has changed.
    ' If it has, resize the arrays.
  
    If mClassifier Is Nothing And general.sonarIF.GetClassifier Is Nothing Then
      Exit Sub ' No classifier, so cannot do much of anything.
    ElseIf Not mClassifier Is general.sonarIF.GetClassifier Then
    
      Set mClassifier = general.sonarIF.GetClassifier
      resizeArrays mClassifier.GetNClasses() - mClassifier.GetNImplicitClasses() + 1 ' for unknown
      PlotLayout
    End If
  
  End If

  mTimesliceCount = mTimesliceCount + 1
  If mTimesliceCount > mTimesliceMax Then
  
    '  All the available time slices are used, so
    '  throw out the oldest one: deduct it from the totals and
    '  adjust the pointers
  
    Dim i As Integer
    For i = 0 To mNBins - 1
      mTotals(i) = mTotals(i) - mCounts(i, mTimesliceFirst)
      mGrandTotal = mGrandTotal - mCounts(i, mTimesliceFirst)
    Next i
    
    mTimesliceCurrent = mTimesliceFirst
    mTimesliceFirst = (mTimesliceFirst + 1) Mod mTimesliceMax
    mTimesliceCount = mTimesliceMax
    
  Else
    mTimesliceCurrent = (mTimesliceCurrent + 1) Mod mTimesliceMax
  End If
  
  mTimes(mTimesliceCurrent) = general.sonarIF.GetPingTime()
  InsertEchoes ' Into the current timeslice
  
  ' Update the totals and the grand total
  
  For i = 0 To mNBins - 1
    mTotals(i) = mTotals(i) + mCounts(i, mTimesliceCurrent)
    mGrandTotal = mGrandTotal + mCounts(i, mTimesliceCurrent)
  Next i
  
  ' If we're showing track counts - gather the info from "FillTrackCountBins"
  
  If IsShowingTrackCounts Then FillTrackCountBins (pingNumber)   '
  
  '  Repaint the plot
  
  PlotPaint

End Sub

Public Sub PlotLayout(Optional ByVal rangeMin As Variant, _
                      Optional ByVal rangeMax As Variant, _
                      Optional ByVal nTimeslices As Variant)
                      
  If Not IsMissing(rangeMin) Then mRangeMin = rangeMin
  If Not IsMissing(rangeMax) Then mRangeMax = rangeMax
  If Not IsMissing(nTimeslices) Then
    If nTimeslices <> mTimesliceMax Then
      resizeArrays nTimeslices:=nTimeslices
    End If
  End If

  ' Compute the averaging constant, using timeFactor as the target halflife
  ' of the averager.
  
  mBarPaneX0 = 2
  mBarPaneX1 = mPicture.ScaleWidth - _
    (mPercentTick + mPercentLabelGap + mPicture.textWidth("80") + 2)
  
  TopAreaLayout
  
  Dim textWidth As Long
  Dim oldfont As Long
  
  oldfont = SelectObject(mPicture.hDC, mFont)
  textWidth = IIf(mPlotType = dptClass, Sqr(mPicture.textWidth("WWWWWWWWW") ^ 2 + mPicture.TextHeight("y^") ^ 2), _
                                      Sqr(mPicture.textWidth("-88.8") ^ 2 + mPicture.TextHeight("y^") ^ 2))
  SelectObject mPicture.hDC, oldfont
  textWidth = maxl(textWidth, mPicture.ScaleHeight * 0.15)
  
  mBarPaneY1 = mPicture.ScaleHeight - (0.5 * textWidth + 4)
  
  mBarWidth = (mBarPaneX1 - mBarPaneX0) * 2 / 3 / mNBins
  mBarSeparation = mBarWidth / 2
  
  CategoryAxisLayout
  
  PlotPaint
  
End Sub

Private Sub PlotPaint()
  
  ' clears plot
  mPicture.Line (mBarPaneX0, mBarPaneY0)-(mBarPaneX1, mBarPaneY1), _
                mPicture.backcolor, BF
                
  ' draws axis
  mPicture.Line (mBarPaneX0, mBarPaneY0)-(mBarPaneX1, mBarPaneY1), _
                mAxisColor, B

  If mShowPercentAxis Then PercentAxisPaint
  If mShowCategoryAxis Then CategoryAxisPaint
  If mShowTopArea Then TopAreaPaint
  
  If IsShowingTrackCounts Then
    DrawTrackCounts         ' draw bars for track counts
    
  Else  ' execute old code
  
    Dim i As Long
    Dim X As Long
    Dim Y As Single
    
    X = mBarPaneX0 + mBarSeparation / 2
  
    For i = 0 To mNBins - 1
      
      If mGrandTotal = 0 Then
        Y = 0
      Else
        Y = (mBarPaneY1 - mBarPaneY0) * mTotals(i) / mGrandTotal
      End If
      
      mPicture.Line (X, mBarPaneY1)-Step(mBarWidth, -Y), mColor(i), BF
      X = X + mBarSeparation + mBarWidth
    Next i
    
  End If
  
  If mHaveFocus Then mPicture_GotFocus
  
End Sub

Public Sub PlotSetup(ByVal prefix As String, _
                     picture As PictureBox, _
                     plotType As DistributionPlotType, _
                     rangeMin As Single, _
                     rangeMax As Single, _
                     ByVal nTimeslices As Integer, _
                     Optional ByVal tsNBins As Integer = 7, _
                     Optional ByVal tsMin As Single = -40, _
                     Optional ByVal tsMax As Single = -20, _
                     Optional ByVal colormap As Variant)
                     
  mPrefix = prefix
  Set mPicture = picture
  mPicture.ScaleMode = vbPixels
  mPicture.AutoRedraw = True
  mAxisColor = IIf(ColorIsDark(mPicture.backcolor), vbWhite, vbBlack)
  mPicture.forecolor = mAxisColor
  mPlotType = plotType
  mRangeMax = rangeMax
  mRangeMin = rangeMin
  mTimesliceMax = nTimeslices
  
  If plotType = dptClass Then
  
    Set mClassifier = general.sonarIF.GetClassifier()
        
    If Not mClassifier Is Nothing Then
    
      resizeArrays mClassifier.GetNClasses() - mClassifier.GetNImplicitClasses() + 1 ' for unknown
    
    End If
  
  Else
  
    resizeArrays tsNBins
    mTSMin = tsMin
    mTSMax = tsMax
  
  End If
  
  '  Get a colormap
    
    If Not IsMissing(colormap) Then
      Set mColormap = colormap
    Else
    
      ' None was provided, so hunt one up.
    
      Set mColormap = New ColorMapClass
      Dim mapName As String
      If plotType = dptClass Then
        If general.sonarIF.GetClassifier() Is Nothing Then
          mapName = "_StandardClass"
        Else
          Set mClassifier = general.sonarIF.GetClassifier()
          mapName = mClassifier.GetColorMapName()
          If mapName = "" Then mapName = "_StandardClass"
        End If
        On Error GoTo mapReadFailed
        mColormap.ReadFromDB mapName
        
mapReadFailed:
        On Error GoTo 0
      Else
        mapName = general.propertyList.GetProperty(prefix & ":ColorMapName", "_StandardEnergy")
        If mapName <> "" Then
          On Error Resume Next
          mColormap.ReadFromDB mapName
          On Error GoTo 0
        End If
      End If
    End If
  
  Me.Clear
  general.sonarIF.addPingListener Me, sonarDataEchoes
  PlotLayout
                      
End Sub

Private Sub resizeArrays(Optional ByVal NBins As Variant, _
                         Optional ByVal nTimeslices As Variant)

  If Not IsMissing(NBins) Then mNBins = NBins
  If Not IsMissing(nTimeslices) Then mTimesliceMax = nTimeslices
  
  ReDim mCounts(0 To mNBins - 1, 0 To mTimesliceMax - 1) As Long
  ReDim mTotals(0 To mNBins - 1) As Long
  
  ReDim mTrackTotals(0 To mNBins - 1) As Long
  
  ReDim mColor(0 To mNBins - 1) As Long
  ReDim mCategoryLabels(0 To mNBins - 1) As String
  ReDim mTimes(0 To mTimesliceMax - 1) As Date
  
  mGrandTotal = 0
  
  mTimesliceCount = 0
  mTimesliceCurrent = 0
  mTimesliceFirst = 1

End Sub

Public Sub TeardownPlot()

  general.sonarIF.removePingListener Me
  Set mPicture = Nothing

End Sub

Private Sub TopAreaLayout()

  ' Allocate room for 2 lines of text with 2 pixels before, after and between.

  mBarPaneY0 = 2 * mPicture.TextHeight("y^") + 6

End Sub

Private Sub TopAreaPaint()

  '  Erase the top area

  mPicture.Line (mBarPaneX0, 0)-(mPicture.ScaleWidth, mBarPaneY0 - 1), mPicture.backcolor, BF
  
  Dim i As Integer
  Dim label As String
  Dim X As Long
  Dim Y As Long
  X = mBarPaneX0 + mBarSeparation / 2 + mBarWidth / 2 + 1
  Y = mBarPaneY0 - mPicture.TextHeight("y^") - 2
  For i = 0 To mNBins - 1
    ' now also generates labels for tracker
    label = Format(IIf(Not IsShowingTrackCounts, mTotals(i), mTrackTotals(i)), "###0")
    mPicture.CurrentX = X - mPicture.textWidth(label) / 2
    mPicture.CurrentY = Y
    mPicture.Print label
    X = X + mBarSeparation + mBarWidth
  Next i
  
  mPicture.CurrentX = mBarPaneX0 + 2
  mPicture.CurrentY = 2
  mPicture.Print GetTitle
  Dim interval As String
  interval = "Interval=" & _
    Format(mTimes(mTimesliceFirst) - mTimes(mTimesliceCurrent), "N:Ss")
  mPicture.CurrentX = mBarPaneX1 - mPicture.textWidth(interval)
  mPicture.CurrentY = 2
  mPicture.Print interval

End Sub

Private Sub mPicture_GotFocus()

  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-Step(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mFocusColor, B
  mPicture.DrawWidth = 1
  mHaveFocus = True

End Sub

Private Sub mPicture_KeyDown(KeyCode As Integer, Shift As Integer)

  Dim altbutton As Boolean
  Dim controlbutton As Boolean
  Dim keyHandled As Boolean
  Dim shiftbutton As Boolean

  shiftbutton = (Shift And vbShiftMask) <> 0
  controlbutton = (Shift And vbCtrlMask) <> 0
  altbutton = (Shift And vbAltMask) <> 0
  
  keyHandled = False
  
  Select Case KeyCode
  
    Case 93 ' Menu key
      RaiseEvent ContextMenuRequest(mPicture.width / 2, mPicture.height / 2)
      keyHandled = True
    
    Case vbKeyF1
      If controlbutton Then
        Dim magicKeys As MagicKeyDisplayClass
        Set magicKeys = New MagicKeyDisplayClass
        
        With magicKeys
          .display
        End With
        Set magicKeys = Nothing
      End If
      
  
  End Select

  If Not keyHandled Then RaiseEvent KeyDown(KeyCode, Shift)

End Sub

Private Sub mPicture_LostFocus()

  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mPicture.backcolor, B
  mPicture.DrawWidth = 1
  mHaveFocus = False

End Sub

Private Sub mPicture_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseDown, Button, Shift, X, Y

End Sub

Private Sub mPicture_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseMove, Button, Shift, X, Y

End Sub

Private Sub mPicture_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseUp, Button, Shift, X, Y

End Sub

Private Sub Class_Initialize()


  mFont = CreateFont(14, 0, -300, 0, FW_NORMAL, False, _
                     False, False, ANSI_CHARSET, OUT_DEFAULT_PRECIS, _
                     CLIP_CHARACTER_PRECIS, PROOF_QUALITY, _
                     VARIABLE_PITCH Or FF_ROMAN Or 4, "Garamond")
                     
  mPercentTick = (0.05 * 1440) / Screen.TwipsPerPixelX
  mPercentLabelGap = mPercentTick / 3
  
  mShowPercentAxis = True
  mShowCategoryAxis = True
  mShowTopArea = True
  mFocusColor = vbYellow
  mHaveFocus = False
  
  Set mMenu = New Scripting.Dictionary
  mMenu.CompareMode = TextCompare
  
  AddMenuItem "&Options", dpaOptions
  AddMenuItem "-", dpaSpace1
  AddMenuItem "&ChangeType", dpaChangeType

  ' for track count display
  mShowCounts = False
  mCountingAllTracks = False
  
End Sub

Public Function IsShowingTrackCounts() As Boolean

  On Error GoTo oops:
  
  IsShowingTrackCounts = mShowCounts
    
  Exit Function
  
oops:
  StoreError
  
End Function

Public Sub SetTrackingOptions(trackOption As Integer)

  On Error GoTo oops:
  
  Select Case trackOption
    Case echoesInHRP
      mShowCounts = False
      mCountingAllTracks = False
      
    Case totalTracks
      mShowCounts = True
      mCountingAllTracks = True
  
    Case trackingInHRP
      mShowCounts = True
      mCountingAllTracks = False
    
    Case Else ' something else???
      Debug.Assert (False)
      mShowCounts = False
      mCountingAllTracks = False
  End Select

  Exit Sub
  
oops:
  ErrorBox
  mShowCounts = False
  mCountingAllTracks = False
  
End Sub

Public Function IsCountingAllTracks() As Boolean

  On Error GoTo oops:
  
  IsCountingAllTracks = mCountingAllTracks
  
  Exit Function
  
oops:
  StoreError
  IsCountingAllTracks = False
  mShowCounts = False
  
End Function

Private Function GetTitle() As String
  
  On Error GoTo oops:
  
  If IsShowingTrackCounts Then
    GetTitle = "total(" & IIf(IsCountingAllTracks, "since start", "interval") _
                                            & ")  = " & Format(mTotalTracks, "####0")
  Else
    GetTitle = "total = " & Format(mGrandTotal, "####0")
  End If
     
  Exit Function
  
oops:
  StoreError
  
End Function

Private Function GetTrackBinCount() As Long

  On Error GoTo oops:
  
  GetTrackBinCount = mNBins
  If mNBins < MIN_NBins Then GetTrackBinCount = MIN_NBins
  If mNBins > MAX_NBins Then GetTrackBinCount = MAX_NBins
  
  Exit Function
  
oops:
  StoreError
  If mShowCounts = True Then mShowCounts = False
  
End Function

Public Function GetTrackPing_Lbound(currentPing As Long)

  On Error GoTo oops:
  
  GetTrackPing_Lbound = IIf(IsCountingAllTracks, 0, currentPing - mTimesliceMax)
  GetTrackPing_Lbound = maxl(1, GetTrackPing_Lbound)    ' Can't include tracks that are spawned durring the 0-th ping
                                                        ' since this would introduce a systematic error...
  Exit Function
  
oops: ' turn off count display
  StoreError
  mShowCounts = False
  
End Function

Public Function GetTrackPing_Ubound(currentPing As Long) As Long

 ' GetTrackPing_Ubound = maxl(0, currentPing - 1)  ' By policy, not including any unfinished tracks
  On Error GoTo oops:
  
  GetTrackPing_Ubound = maxl(0, currentPing)      ' Now including unfished tracks - Up to present
  
  Exit Function
  
oops: ' turn off count display
  StoreError
  mShowCounts = False
  
End Function

Private Sub FillTrackCountBins(currentPing As Long)

  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Comment - When we add acoustive color it might make sense to divide the bulk of this _
  method into 3+1 methods.  (FillTrackCountBins would then call "TrackCountByColor", _
  "TrackCountByTS", "TrackCountByClass"...) _
  -- REB 2002.08.27
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  Dim index As Integer          ' Loop index
  Dim numberOfBins As Integer   ' The number of bins
  Dim count As Integer          ' The count in a particular bin

  Dim startPoint As Long        ' First ping whose tracks can be included
  Dim endPoint As Long          ' Tracks can't continue past this points
  Dim closest As Double         ' Tracks can't start closer than this
  Dim farthest As Double        ' Tracks can't start farther than this
  
  ' these three are only needed for counts binned by TS
  Dim lowerTS As Double         ' Lower bound of TS bin
  Dim upperTS As Double         ' Upper bound of TS bin
  Dim tsBinWidth As Single
  
  ' reset the total number of tracks
  mTotalTracks = 0
  
  ' initial values for parameters
  numberOfBins = GetTrackBinCount
  startPoint = GetTrackPing_Lbound(currentPing)
  endPoint = GetTrackPing_Ubound(currentPing)
  closest = mRangeMin
  farthest = mRangeMax

  If mPlotType = dptClass Then ' count by class
    For index = 0 To numberOfBins - 1
      ' get count
      count = general.sonarIF.trx.GetCountByClass((closest), (farthest), (index), (startPoint), (endPoint))
      mTrackTotals(index) = count
      mTotalTracks = mTotalTracks + count
    Next index
  
  ElseIf mPlotType = dptTargetStrength Then ' count by TS
    ' set initial values
    tsBinWidth = (mTSMax - mTSMin) / (mNBins - 2)
    lowerTS = -VERY_BIG_NUMBER        ' first bin has no lower limit.
    upperTS = mTSMin
    
    For index = 0 To numberOfBins - 1
      ' get count
      count = general.sonarIF.trx.GetCountTracksByTS(closest, farthest, lowerTS, _
                                                        upperTS, startPoint, endPoint)
      mTrackTotals(index) = count
      mTotalTracks = mTotalTracks + count
      
      ' update TS boundaries
      lowerTS = upperTS
      upperTS = IIf((numberOfBins - 2) <> index, (upperTS + tsBinWidth), VERY_BIG_NUMBER) ' last bin has no upper limit
    Next index
    
  End If
  
  Exit Sub

oops:
  StoreError
  Resume Next
  
End Sub

Private Sub DrawTrackCounts()
  
  On Error GoTo oops:
  
  Dim i As Long
  Dim X As Long
  Dim Y As Single
  
  Dim oldDrawStyle As Long
  Dim oldFillColor As Long
  Dim oldFillStyle As Long
  
  oldDrawStyle = mPicture.DrawStyle       ' used for X-fillstyle
  oldFillColor = mPicture.FillColor       ' used for X-fillstyle
  oldFillStyle = mPicture.FillStyle
  
  On Error GoTo oops2:
  mPicture.FillStyle = vbDiagonalCross    ' used for X-fillstyle
  
  X = mBarPaneX0 + mBarSeparation / 2
  
  For i = 0 To mNBins - 1
    mPicture.FillColor = mColor(i)        ' used for X-fillstyle
    If mTotalTracks = 0 Then
      Y = 0
    Else
      Y = (mBarPaneY1 - mBarPaneY0) * mTrackTotals(i) / mTotalTracks
    End If

    mPicture.Line (X, mBarPaneY1)-Step(mBarWidth, -Y), mColor(i), B
    X = X + mBarSeparation + mBarWidth
  Next i
  
reentry:
  mPicture.FillColor = oldFillColor       ' used for X-fillstyle
  mPicture.DrawStyle = oldDrawStyle       ' used for X-fillstyle
  mPicture.FillStyle = oldFillStyle
  
  Exit Sub
  
oops:
  StoreError
  Exit Sub
  
oops2:
  StoreError
  Select Case MyStoredError.number
    Case 11 ' divide by zero
      Y = 0
      Resume Next
    Case 9 ' array out of bounds
      Resume reentry:
    Case Else ' unanticipated error
      ' do nothing
  End Select

  Resume reentry:

End Sub

Private Function IsTracking() As Boolean

  On Error GoTo oops:
  
  IsTracking = general.sonarIF.trx.IsTracking
  
  Exit Function
  
oops: ' If there is an error then stop displaying tracks...
  StoreError
  IsTracking = False
  mShowCounts = False
  
End Function
